﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;
using Gemini.Core.JSON.LitJson;
using System.Xml.Xsl;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodUserProfileSave : BaseAPIMethod
        {
            private string _data = null;

            public MethodUserProfileSave(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "usersprofilesave"; }
            }

            protected override bool DoValidate()
            {
                return  (!string.IsNullOrEmpty(_data));
            }

            protected override void DoReadRequestParams()
            {
                _data = Component.APIRequestParams["data"];
            }

            protected override GResponseData DoGetGResponseData()
            {
                if (User != null)
                {
                    try
                    {
                        GUserProfileDataSave _GUserProfileDataSave = JsonMapper.ToObject<GUserProfileDataSave>(_data);

                        BL.Dictionary.GroupType _group = (BL.Dictionary.GroupType)User.GroupEnumID;

                        if (_group == BL.Dictionary.GroupType.Student)
                        {
                            PI.ZB.N1200.ELearning.BL.BO.Student _student = Component.BLELearning.Student.RestoreByUser(User);
                            if (_student != null)
                            {
                                _student.Email = _GUserProfileDataSave.email;
                                _student.Forename = _GUserProfileDataSave.name;
                                _student.Surename = _GUserProfileDataSave.surname;

                                Gemini.Core.BL.Base.MethodResult _metodhResult = Component.BLELearning.Student.Save(_student);

                                if (_metodhResult.Success == true)
                                {
                                    StatusCode = StatusCodeType.OK;
                                    return new GResponseData();
                                }
                                else
                                {
                                    AddErrorMessage(_metodhResult.GetAllText());
                                    StatusCode = StatusCodeType.NotAcceptable;
                                }
                            }
                            else
                            {
                                AddErrorMessage("Nie można odzyskać danych studenta dla zadanych parametrów wejściowych.");
                                StatusCode = StatusCodeType.BadRequest;
                            }

                        }
                    }
                    catch
                    {
                        AddErrorMessage("Niepoprawny ciąg danych wejściowych do zapisu ćwiczenia.");
                        StatusCode = StatusCodeType.BadRequest;
                    }                    
                }
                return null;
            }
        }
    }
}
